/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.jspemul;

import com.ibm.hwmca.fw.servlet.jspemul.JSPEmulatorException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;

class TagPool {
    private static final String TRACE_MASKT = "XJSPTPLT";
    Map tagkeyToHandlerList = new HashMap();
    TagDescriptor testDescriptor;

    public Tag getHandlerFromPool(String className, String[] attributeNames) throws JSPEmulatorException {
        if (this.testDescriptor == null) {
            this.testDescriptor = new TagDescriptor(className, attributeNames);
        } else {
            this.testDescriptor.setParms(className, attributeNames);
        }
        List handlers = (List)this.tagkeyToHandlerList.get(this.testDescriptor);
        if (handlers == null || handlers.isEmpty()) {
            return this.testDescriptor.getInstance();
        }
        return (Tag)handlers.remove(handlers.size() - 1);
    }

    public void putHandlerInPool(String className, String[] attributeNames, Tag handler) {
        this.testDescriptor.setParms(className, attributeNames);
        ArrayList<Tag> handlers = (ArrayList<Tag>)this.tagkeyToHandlerList.get(this.testDescriptor);
        if (handlers == null) {
            handlers = new ArrayList<Tag>(5);
            this.tagkeyToHandlerList.put(this.testDescriptor.clone(), handlers);
        }
        handlers.add(handler);
    }

    public void releaseAllHandlers() {
        Iterator iterator = this.tagkeyToHandlerList.values().iterator();
        while (iterator.hasNext()) {
            List tags = (List)iterator.next();
            Iterator jiterator = tags.iterator();
            while (jiterator.hasNext()) {
                Tag tag = (Tag)jiterator.next();
                try {
                    tag.release();
                }
                catch (Throwable e) {
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Trace.trace(TRACE_MASKT, "Ignoring exception from Tag.release() on custom JSP tag handler");
                    Trace.trace(TRACE_MASKT, e);
                }
            }
        }
        this.tagkeyToHandlerList.clear();
        this.testDescriptor = null;
    }

    private static class TagDescriptor
    implements Cloneable {
        private String className;
        private String[] attributeNames;
        private int hash;

        TagDescriptor(String className, String[] attributeNames) {
            this.setParms(className, attributeNames);
        }

        void setParms(String className, String[] attributeNames) {
            Arrays.sort(attributeNames);
            this.className = className;
            this.attributeNames = attributeNames;
            this.hash = 0;
        }

        Tag getInstance() throws JSPEmulatorException {
            try {
                return (Tag)Class.forName(this.className).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JSPEmulatorException("Tag handler class not found", e);
            }
            catch (InstantiationException e) {
                throw new JSPEmulatorException("Error instantiating tag handler class", e);
            }
            catch (IllegalAccessException e) {
                throw new JSPEmulatorException("Tag handler class not public", e);
            }
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.className.hashCode();
                if (this.attributeNames != null) {
                    int i = 0;
                    while (i < this.attributeNames.length) {
                        this.hash ^= this.attributeNames[i].hashCode();
                        ++i;
                    }
                }
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TagDescriptor)) {
                return false;
            }
            TagDescriptor other = (TagDescriptor)obj;
            if (!this.className.equals(other.className)) {
                return false;
            }
            if (this.attributeNames == null != (other.attributeNames == null)) {
                return false;
            }
            if (this.attributeNames == null) {
                return true;
            }
            if (this.attributeNames.length != other.attributeNames.length) {
                return false;
            }
            int i = 0;
            while (i < this.attributeNames.length) {
                if (!this.attributeNames[i].equals(other.attributeNames[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            return "TagPool[className=" + this.className + ",attributeNames.length=" + this.attributeNames.length;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

